
// OpenGLBaseView.cpp : COpenGLBaseView NX̎
//

#include "stdafx.h"
// SHARED_HANDLERS ́Avr[AkŁAьtB^[ nh[Ă ATL vWFNgŒ`łA
// ̃vWFNgƂ̃hLg R[h̋L\ɂ܂B
#ifndef SHARED_HANDLERS
//#include "OpenGLBase.h"
#endif

//#include "OpenGLBaseDoc.h"
#include "OpenGLBaseView.h"

#pragma comment( lib, "opengl32.lib" )
#pragma comment( lib, "glu32.lib" )

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// COpenGLBaseView

IMPLEMENT_DYNCREATE(COpenGLBaseView, CView)

BEGIN_MESSAGE_MAP(COpenGLBaseView, CView)
	ON_WM_ERASEBKGND()
	ON_WM_SIZE()
	ON_WM_DESTROY()
END_MESSAGE_MAP()

// COpenGLBaseView RXgNV/fXgNV

COpenGLBaseView::COpenGLBaseView() :
	m_hRC( NULL ),
	m_pDC( NULL ),
	m_cx( 0 ),
	m_cy( 0 )
{
	// TODO: \zR[hɒǉ܂B

}

COpenGLBaseView::~COpenGLBaseView()
{
}

BOOL COpenGLBaseView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ̈ʒu CREATESTRUCT cs C Window NX܂̓X^C
	//  CĂB
	cs.style |= WS_CLIPSIBLINGS | WS_CLIPCHILDREN;

	return CView::PreCreateWindow(cs);
}

// COpenGLBaseView `

void COpenGLBaseView::OnDraw(CDC* /*pDC*/)
{
	CDocument* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	if (!pDoc)
		return;

	// TODO: ̏ꏊɃlCeBu f[^p̕`R[hǉ܂B
	if( !m_pDC )
	{
		return;
	}

	// _OReLXg̐ݒ
	// MDI`ɂĕK{BSDIɂĂ͏ȗ(InitializeOpenGL֐ŌĂяoς݂Ȃ̂ŁjB
	// ȍ~OpenGL֐ɂ`́Aw肵_OReLXɕ`悳B
	wglMakeCurrent( m_pDC->GetSafeHdc(), m_hRC );

	glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

	PreRenderScene();

	glPushMatrix();
	RenderStockScene();
	glPopMatrix();

	glPushMatrix();
	RenderScene();
	glPopMatrix();

	PostRenderScene();

	glFinish();

	SwapBuffers( m_pDC->GetSafeHdc() );
}

// COpenGLBaseView ff

#ifdef _DEBUG
void COpenGLBaseView::AssertValid() const
{
	CView::AssertValid();
}

void COpenGLBaseView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CDocument* COpenGLBaseView::GetDocument() const // fobOȊÕo[W̓CCłB
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDocument)));
	return (CDocument*)m_pDocument;
}
#endif //_DEBUG

bool COpenGLBaseView::InitializeOpenGL()
{
	// foCXReLXg̍쐬
	m_pDC = new CClientDC( this );
	if( NULL == m_pDC )
	{
		ASSERT( !"m_pDC is NULL" );
		return false;
	}

	// OpenGL pixel format ̐ݒ
	if( !SetupPixelFormat() )
	{
		ASSERT( !"SetupPixelFormat failed" );
		return false;
	}

	// _OReLXg̍쐬
	m_hRC = wglCreateContext( m_pDC->GetSafeHdc() );
	if( 0 == m_hRC )
	{
		ASSERT( !"wglCreateContext failed" );
		return false;
	}

	// _OReLXg̐ݒ
	if( TRUE != wglMakeCurrent( m_pDC->GetSafeHdc(), m_hRC ) )
	{
		ASSERT( !"wglMakeCurrent failed" );
		return false;
	}

	// OpenGLg@\g悤ɂ
	if( !InitOpenGLExtFuncs() )
	{
		ASSERT( !"InitOpenGLExtFuncs failed" );
		return false;
	}

	// NA
	glClearColor( 0, 0, 0, 0 );	// NAJ[
	glClearDepth( 1.0f );	// NA[x

	// fvX
	glEnable( GL_DEPTH_TEST );	// fvXeXg
	glDepthFunc( GL_LEQUAL );	//fvXt@NiAOɂ̂ŏ`Ăj

	// |S
	glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );	// |SiGL_TRIANGLESj́AʋhԂB
	glDisable( GL_CULL_FACE ); // Ăʂ̃JOiJOȂʂ`j
	glEnable( GL_POLYGON_OFFSET_FILL ); // |SItZbgtBiʂƐdȂꍇ̃JXh~j
	glPolygonOffset( 1.0f, 1.0f ); // |SItZbg

	// CeBO
	glDisable( GL_LIGHTING ); // 
	glEnable( GL_NORMALIZE ); // OpenGLŖ@xNgPʖ@xNg悤ɂ
	glDisable( GL_COLOR_MATERIAL ); // J[ݒl}eAƂĎgp

	return true;
}

bool COpenGLBaseView::SetupPixelFormat()
{
	static PIXELFORMATDESCRIPTOR pfd =
	{
		sizeof( PIXELFORMATDESCRIPTOR ),
		1,
		PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER,
		PFD_TYPE_RGBA,
		24,
		0, 0, 0, 0, 0, 0,
		0,
		0,
		0,
		0, 0, 0, 0,
		32,
		0,
		0,
		PFD_MAIN_PLANE,
		0,
		0, 0, 0
	};

	int iPixelFormat;
	if( 0 == ( iPixelFormat = ChoosePixelFormat( m_pDC->GetSafeHdc(), &pfd ) ) )
	{
		ASSERT( !"ChoosePixelFormat is failed" );
		return FALSE;
	}

	if( TRUE != SetPixelFormat( m_pDC->GetSafeHdc(), iPixelFormat, &pfd ) )
	{
		ASSERT( !"SetPixelFormat is failed" );
		return FALSE;
	}

	return true;
}

void COpenGLBaseView::UninitializeOpenGL()
{
	wglMakeCurrent( NULL, NULL );
	if( m_hRC )
	{
		wglDeleteContext( m_hRC );
		m_hRC = NULL;
	}
	if( m_pDC )
	{
		delete m_pDC;
		m_pDC = NULL;
	}
}

bool COpenGLBaseView::SetupViewport()
{
	glViewport( 0,
		0,
		m_cx,
		m_cy );
	return true;
}

bool COpenGLBaseView::SetupProjectionMatrix()
{
	glMatrixMode( GL_PROJECTION );
	glLoadIdentity();

	glOrtho( -m_cx * 0.5 / 10.0,
		m_cx * 0.5 / 10.0,
		-m_cy * 0.5 / 10.0,
		m_cy * 0.5 / 10.0,
		0.1,
		1000.0 );

	// eϊsɑ΂鏈͂ŊB
	// ȍ~̕ϊs񏈗́Afr[ϊsɑ΂Ď{悤ɂB
	glMatrixMode( GL_MODELVIEW );
	return true;
}

bool COpenGLBaseView::SetupModelViewMatrix()
{
	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity();

	gluLookAt( 0.0, 0.0, 500.0,	// _
		0.0, 0.0, 0.0,	// _
		0.0, 1.0, 0.0 );	// xNg

	return true;
}

void COpenGLBaseView::RenderStockScene()
{
	RenderAxis();
}

void COpenGLBaseView::RenderAxis()
{
	float	points[4][3];
	points[0][0] = 0.0;
	points[0][1] = 0.0;
	points[0][2] = 0.0;
	points[1][0] = 10;
	points[1][1] = 0.0;
	points[1][2] = 0.0;
	points[2][0] = 0.0;
	points[2][1] = 10;
	points[2][2] = 0.0;
	points[3][0] = 0.0;
	points[3][1] = 0.0;
	points[3][2] = 10;

	glPushAttrib( GL_CURRENT_BIT | GL_LINE_BIT );	// F | 

	glLineWidth( 2.0 );
	glBegin( GL_LINES );
	glColor3ub( 255, 0, 0 );
	glVertex3fv( points[0] );
	glVertex3fv( points[1] );
	glColor3ub( 0, 255, 0 );
	glVertex3fv( points[0] );
	glVertex3fv( points[2] );
	glColor3ub( 0, 0, 255 );
	glVertex3fv( points[0] );
	glVertex3fv( points[3] );
	glEnd();

	glPopAttrib();
}

// COpenGLBaseView bZ[W nh[


BOOL COpenGLBaseView::OnEraseBkgnd( CDC* pDC )
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B
	return TRUE;

	//return CView::OnEraseBkgnd( pDC );
}


void COpenGLBaseView::OnSize( UINT nType, int cx, int cy )
{
	CView::OnSize( nType, cx, cy );

	// TODO: ɃbZ[W nh[ R[hǉ܂B
	if( 0 >= cx || 0 >= cy )
	{
		return;
	}

	if( NULL == m_hRC )
	{
		// OpenGL
		InitializeOpenGL();
	}

	if( NULL != m_hRC )
	{
		// ʑ傫̐ݒ
		m_cx = cx;
		m_cy = cy;

		// r[|[g̐ݒ
		SetupViewport();

		// eϊs̐ݒ
		SetupProjectionMatrix();

		// fOr[COϊs̐ݒ
		SetupModelViewMatrix();
	}
}


void COpenGLBaseView::OnDestroy()
{
	CView::OnDestroy();

	// TODO: ɃbZ[W nh[ R[hǉ܂B
	UninitializeOpenGL();
}
