
// OpenGLPickView.cpp : COpenGLPickView NX̎
//

#include "stdafx.h"
// SHARED_HANDLERS ́Avr[AkŁAьtB^[ nh[Ă ATL vWFNgŒ`łA
// ̃vWFNgƂ̃hLg R[h̋L\ɂ܂B
#ifndef SHARED_HANDLERS
#include "OpenGLPick.h"
#endif

#include "OpenGLPickDoc.h"
#include "OpenGLPickView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// COpenGLPickView

IMPLEMENT_DYNCREATE(COpenGLPickView, COpenGLTrackView)

BEGIN_MESSAGE_MAP(COpenGLPickView, COpenGLTrackView)
	ON_WM_SIZE()
	ON_WM_RBUTTONUP()
END_MESSAGE_MAP()

// COpenGLPickView RXgNV/fXgNV

COpenGLPickView::COpenGLPickView()
{
	// TODO: \zR[hɒǉ܂B
	memset( m_auiName_picked, 0x00, NAMEARRAYSIZE * sizeof( unsigned int ) );

	m_uiTextureID = 0;
	m_uiRenderBufferID = 0;
	m_uiFrameBufferID = 0;
}

COpenGLPickView::~COpenGLPickView()
{
}

BOOL COpenGLPickView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ̈ʒu CREATESTRUCT cs C Window NX܂̓X^C
	//  CĂB

	return COpenGLTrackView::PreCreateWindow(cs);
}

// COpenGLPickView `

//void COpenGLPickView::OnDraw(CDC* /*pDC*/)
//{
//	COpenGLPickDoc* pDoc = GetDocument();
//	ASSERT_VALID(pDoc);
//	if (!pDoc)
//		return;
//
//	// TODO: ̏ꏊɃlCeBu f[^p̕`R[hǉ܂B
//}


// COpenGLPickView ff

#ifdef _DEBUG
void COpenGLPickView::AssertValid() const
{
	COpenGLTrackView::AssertValid();
}

void COpenGLPickView::Dump(CDumpContext& dc) const
{
	COpenGLTrackView::Dump(dc);
}

COpenGLPickDoc* COpenGLPickView::GetDocument() const // fobOȊÕo[W̓CCłB
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(COpenGLPickDoc)));
	return (COpenGLPickDoc*)m_pDocument;
}
#endif //_DEBUG

void COpenGLPickView::CreateFrameBuffer( int iWidth, int iHeight )
{
	// O̐
	if( 0 == m_uiTextureID )
	{
		glGenTextures( 1, &m_uiTextureID );
		glGenRenderbuffers( 1, &m_uiRenderBufferID );
		glGenFramebuffers( 1, &m_uiFrameBufferID );
	}

	// eNX`̍\z
	glBindTexture( GL_TEXTURE_2D, m_uiTextureID );	// eNX`̃oCh
	glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, m_cx, m_cy, 0, GL_RGBA, GL_UNSIGNED_BYTE, NULL );
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );	// Ƃ߂Z̐FgpFԂȂBGL_LINEAŔAFԂB
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );	// Ƃ߂Z̐FgpFԂȂBGL_LINEAŔAFԂB
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP ); // 摜̒[̃sNZ̐Fg
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP ); // 摜̒[̃sNZ̐Fg
	glBindTexture( GL_TEXTURE_2D, 0 );	// oCh̉

	// _[obt@[̍\z
	glBindRenderbuffer( GL_RENDERBUFFER, m_uiRenderBufferID );		// _[obt@̃oCh
	glRenderbufferStorage( GL_RENDERBUFFER, GL_DEPTH_COMPONENT16, m_cx, m_cy );		// _[obt@̐[xATCY̐ݒ
	glBindRenderbuffer( GL_RENDERBUFFER, 0 ); // oCh̉
}

void COpenGLPickView::DestroyFrameBuffer()
{
	if( 0 == m_uiTextureID )
	{
		return;
	}

	glDeleteFramebuffers( 1, &m_uiFrameBufferID );
	glDeleteRenderbuffers( 1, &m_uiRenderBufferID );
	glDeleteTextures( 1, &m_uiTextureID );

	m_uiFrameBufferID = 0;
	m_uiRenderBufferID = 0;
	m_uiTextureID = 0;
}

void COpenGLPickView::UninitializeOpenGL()
{
	DestroyFrameBuffer();

	COpenGLTrackView::UninitializeOpenGL();
}

bool COpenGLPickView::RenderScene()
{
	RenderModel( RM_RENDER );

	return true;
}

void COpenGLPickView::RenderModel( ERENDERMODE eRenderMode )
{
	unsigned int uiCountPoint = 8;
	float points[8][3] = { -5, -5, -5,
							  5, -5, -5,
							  5,  5, -5,
							 -5,  5, -5,
							 -5, -5,  5,
							  5, -5,  5,
							  5,  5,  5,
							 -5,  5,  5 };
	unsigned int uiCountTriangle = 12;
	unsigned int triangles[12][3] = { 0, 1, 3,
							  1, 2, 3,
							  1, 5, 2,
							  5, 6, 2,
							  5, 4, 6,
							  4, 7, 6,
							  4, 0, 7,
							  0, 3, 7,
							  3, 2, 7,
							  2, 6, 7,
							  4, 5, 0,
							  5, 1, 0 };
	unsigned int uiIndexTriangle;
	unsigned int uiIndexLine;
	unsigned int uiIndexPoint;
	unsigned int ui3;

	glPushAttrib( GL_ALL_ATTRIB_BITS );	// Agr[gAł悤ɁAǉ

	// 
	if( RM_RENDER == eRenderMode )
	{
		glColor3f( 0.5f, 0.5f, 0.0f );
	}
	if( RM_PICK_ELEMENTTYPE == eRenderMode )
	{
		glColor3f( 1.0f, 0.0f, 0.0f );
	}
	for( uiIndexTriangle = 0; uiIndexTriangle < uiCountTriangle; uiIndexTriangle++ )
	{
		if( RM_PICK_ELEMENTID == eRenderMode )
		{
			glColor3ub( GetRValue(uiIndexTriangle), GetGValue(uiIndexTriangle), GetBValue(uiIndexTriangle) );
		}
		glBegin( GL_TRIANGLES );
		glVertex3fv( points[triangles[uiIndexTriangle][0]] );
		glVertex3fv( points[triangles[uiIndexTriangle][1]] );
		glVertex3fv( points[triangles[uiIndexTriangle][2]] );
		glEnd();
	}
	// sbNʂ̕`
	if( RM_RENDER == eRenderMode )
	{
		if( RET_FACE == m_auiName_picked[1] )
		{
			uiIndexTriangle = m_auiName_picked[2];
			glColor3f( 1.0f, 1.0f, 0.0f );	// sbNF
			glBegin( GL_TRIANGLES );
			glVertex3fv( points[triangles[uiIndexTriangle][0]] );
			glVertex3fv( points[triangles[uiIndexTriangle][1]] );
			glVertex3fv( points[triangles[uiIndexTriangle][2]] );
			glEnd();
		}
	}
	// 
	glLineWidth( 2.0 );
	if( RM_RENDER == eRenderMode )
	{
		glColor3f( 0.0f, 0.5f, 0.5f );
	}
	if( RM_PICK_ELEMENTTYPE == eRenderMode )
	{
		glColor3f( 0.0f, 1.0f, 0.0f );
	}
	for( uiIndexTriangle = 0; uiIndexTriangle < uiCountTriangle; ++uiIndexTriangle )
	{
		for( ui3 = 0; ui3 < 3; ++ui3 )
		{
			if( RM_PICK_ELEMENTID == eRenderMode )
			{
				uiIndexLine = uiIndexTriangle * 3 + ui3;
				glColor3ub( GetRValue(uiIndexLine), GetGValue(uiIndexLine), GetBValue(uiIndexLine) );
			}
			glBegin( GL_LINES );
			glVertex3fv( points[triangles[uiIndexTriangle][( ui3 + 0 ) % 3]] );
			glVertex3fv( points[triangles[uiIndexTriangle][( ui3 + 1 ) % 3]] );
			glEnd();
		}
	}
	// sbN̕`
	if( RM_RENDER == eRenderMode )
	{
		if( RET_LINE == m_auiName_picked[1] )
		{
			uiIndexLine = m_auiName_picked[2];
			uiIndexTriangle = uiIndexLine / 3;
			ui3 = uiIndexLine % 3;
			glLineWidth( 5.0f );
			glColor3f( 0.0f, 1.0f, 1.0f );
			glBegin( GL_LINES );
			glVertex3fv( points[triangles[uiIndexTriangle][( ui3 + 0 ) % 3]] );
			glVertex3fv( points[triangles[uiIndexTriangle][( ui3 + 1 ) % 3]] );
			glEnd();
		}
	}
	// _
	glPointSize( 5.0 );
	if( RM_RENDER == eRenderMode )
	{
		glColor3f( 0.5f, 0.0f, 0.5f );
	}
	if( RM_PICK_ELEMENTTYPE == eRenderMode )
	{
		glColor3f( 0.0f, 0.0f, 1.0f );
	}
	for( uiIndexPoint = 0; uiIndexPoint < uiCountPoint; uiIndexPoint++ )
	{
		if( RM_PICK_ELEMENTID == eRenderMode )
		{
			glColor3ub( GetRValue(uiIndexPoint), GetGValue(uiIndexPoint), GetBValue(uiIndexPoint) );
		}
		glBegin( GL_POINTS );
		glVertex3fv( points[uiIndexPoint] );
		glEnd();
	}
	// sbN_̕`
	if( RM_RENDER == eRenderMode )
	{
		if( RET_POINT == m_auiName_picked[1] )
		{
			glPointSize( 10.0f );
			glColor3f( 1.0f, 0.0f, 1.0f );
			uiIndexPoint = m_auiName_picked[2];
			glBegin( GL_POINTS );
			glVertex3fv( points[uiIndexPoint] );
			glEnd();
		}
	}

	glPopAttrib();	// Agr[g̕A
	return;
}

// sbLO
int COpenGLPickView::DoPicking( int x, int y )
{
	// t[obt@̃oCh
	glBindFramebuffer( GL_FRAMEBUFFER, m_uiFrameBufferID );
	// J[A^b`gƂăeNX`w肷
	glFramebufferTexture2D( GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, GL_TEXTURE_2D, m_uiTextureID, 0 );
	// [xA^b`gƂă_[obt@w肷
	glFramebufferRenderbuffer( GL_FRAMEBUFFER, GL_DEPTH_ATTACHMENT, GL_RENDERBUFFER, m_uiRenderBufferID );

	int iCountHit = 0;
	int iStatus = glCheckFramebufferStatus( GL_FRAMEBUFFER );
	if( GL_FRAMEBUFFER_COMPLETE != iStatus )
	{	// t[obt@[SłȂ
		// EBhEVXe񋟂t[obt@ɍւ
		glBindFramebuffer( GL_FRAMEBUFFER, 0 );
		return false;
	}

	GLubyte r;
	GLubyte g;
	GLubyte b;

	// O̔z
	unsigned int aauiNamePickRegionPixel[PICKREGIONPIXELCOUNT][NAMEARRAYSIZE];
	// O̔z̏
	memset( aauiNamePickRegionPixel, 0x00, PICKREGIONPIXELCOUNT * NAMEARRAYSIZE * sizeof( unsigned int ) );
	// sNZF̔z
	GLubyte abtColorPickRegionPixel[PICKREGIONPIXELCOUNT * 4];
	// sNZF̔z̏
	memset( abtColorPickRegionPixel, 0x00, PICKREGIONPIXELCOUNT * 4 * sizeof( GLubyte ) );

	glDisable( GL_LIGHTING ); // 
	glDisable( GL_BLEND ); // уA`GCAVO

	// sbN`ivf^Cvʁj
	glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
	RenderModel( RM_PICK_ELEMENTTYPE );
	glReadPixels( x - PICKREGIONOFFSET,
		m_cy - y - PICKREGIONOFFSET,
		1 + 2 * PICKREGIONOFFSET,
		1 + 2 * PICKREGIONOFFSET,
		GL_RGBA,
		GL_UNSIGNED_BYTE,
		abtColorPickRegionPixel );
	// sbN̈̐FsbNzɕϊ
	for( unsigned int ui = 0; ui < PICKREGIONPIXELCOUNT; ++ui )
	{
		r = abtColorPickRegionPixel[ui * 4 + 0];
		g = abtColorPickRegionPixel[ui * 4 + 1];
		b = abtColorPickRegionPixel[ui * 4 + 2];
		if( 255 == r )
		{ // 
			aauiNamePickRegionPixel[ui][1] = RET_FACE;
			++iCountHit;
		}
		else if( 255 == g )
		{ // 
			aauiNamePickRegionPixel[ui][1] = RET_LINE;
			++iCountHit;
		}
		else if( 255 == b )
		{ // _
			aauiNamePickRegionPixel[ui][1] = RET_POINT;
			++iCountHit;
		}
	}
	if( 0 != iCountHit )
	{ // qbg
		// sbN`ivfԍʁj
		glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
		RenderModel( RM_PICK_ELEMENTID );
		glReadPixels( x - PICKREGIONOFFSET,
			m_cy - y - PICKREGIONOFFSET,
			1 + 2 * PICKREGIONOFFSET,
			1 + 2 * PICKREGIONOFFSET,
			GL_RGBA,
			GL_UNSIGNED_BYTE,
			abtColorPickRegionPixel );
		// sbN̈̐FsbNzɕϊ
		for( unsigned int ui = 0; ui < PICKREGIONPIXELCOUNT; ui++ )
		{
			r = abtColorPickRegionPixel[ui * 4 + 0];
			g = abtColorPickRegionPixel[ui * 4 + 1];
			b = abtColorPickRegionPixel[ui * 4 + 2];
			// FԍɕϊAOzɃZbg
			aauiNamePickRegionPixel[ui][2] = RGB( r, g, b );
		}

		// sbN̈sNZӒ肵AsbNvf肷
		IdentifyPickRegionPixels( PICKREGIONPIXELCOUNT, aauiNamePickRegionPixel );
	}

	// EBhEVXe񋟂t[obt@ɍւ
	glBindFramebuffer( GL_FRAMEBUFFER, 0 );

	return ( 0 != iCountHit );
}

// sbN̈sNZӒ肵AsbNvf肷
void COpenGLPickView::IdentifyPickRegionPixels( unsigned int uiCountPickRegionPixel, unsigned int aauiNamePickRegionPixel[][NAMEARRAYSIZE] )
{
	int  iId_selected = -1;
	unsigned int  uiElementType_selected = RET_FACE + 1;
	long lSquareDist_selected = ( 2 + PICKREGIONOFFSET ) * ( 2 + PICKREGIONOFFSET ) + ( 2 + PICKREGIONOFFSET ) * ( 2 + PICKREGIONOFFSET );
	long lSquareDist_current;
	int  x;
	int  y;
	for( unsigned int ui = 0; ui < uiCountPickRegionPixel; ui++ )
	{
		if( 0 == aauiNamePickRegionPixel[ui][1] )
		{ // f̊O
			continue;
		}
		if( uiElementType_selected < aauiNamePickRegionPixel[ui][1] )
		{ // vf^CvIɁAD揇ʂႢ
			continue;
		}
		if( uiElementType_selected > aauiNamePickRegionPixel[ui][1] )
		{ // vf^CvIɁAD揇ʂႢ
			iId_selected = ui;
			uiElementType_selected = aauiNamePickRegionPixel[ui][1];
			x = ui % ( 1 + 2 * PICKREGIONOFFSET ) - PICKREGIONOFFSET;
			y = ui / ( 1 + 2 * PICKREGIONOFFSET ) - PICKREGIONOFFSET;
			lSquareDist_selected = x * x + y * y;
			continue;
		}
		// vf^CvIɁAD揇ʂꍇ́AsbN̈̒Sɋ߂̂DxB
		x = ui % ( 1 + 2 * PICKREGIONOFFSET ) - PICKREGIONOFFSET;
		y = ui / ( 1 + 2 * PICKREGIONOFFSET ) - PICKREGIONOFFSET;
		lSquareDist_current = x * x + y * y;
		if( lSquareDist_selected > lSquareDist_current )
		{
			iId_selected = ui;
			uiElementType_selected = aauiNamePickRegionPixel[ui][1];
			lSquareDist_selected = lSquareDist_current;
			continue;
		}
	}

	if( -1 == iId_selected )
	{
		return;
	}

	// O񃁃o̍XV
	memcpy( m_auiName_picked, aauiNamePickRegionPixel[iId_selected], NAMEARRAYSIZE * sizeof( unsigned int ) );
}

// COpenGLPickView bZ[W nh[


void COpenGLPickView::OnSize( UINT nType, int cx, int cy )
{
	COpenGLTrackView::OnSize( nType, cx, cy );

	// TODO: ɃbZ[W nh[ R[hǉ܂B
	if( 0 >= cx || 0 >= cy )
	{
		return;
	}

	CreateFrameBuffer( cx, cy );
}


void COpenGLPickView::OnRButtonUp( UINT nFlags, CPoint point )
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B
	if( 0 < DoPicking( point.x, point.y ) )
	{	// sbNɐĕ`
		Invalidate( FALSE );
		return;
	}

	COpenGLTrackView::OnRButtonUp( nFlags, point );
}
