package com.hiramine.modelvieweretude;

import java.nio.FloatBuffer;

public class Material
{
	private FloatBuffer	m_fbAmbient;
	private FloatBuffer	m_fbDiffuse;
	private FloatBuffer	m_fbSpecular;
	private float		m_fShininess;

	public Material( float[] f4Ambient, float[] f4Diffuse, float[] f4Specular, float fShininess )
	{
		m_fbAmbient = OpenGLBaseRenderer.makeFloatBuffer( f4Ambient );
		m_fbDiffuse = OpenGLBaseRenderer.makeFloatBuffer( f4Diffuse );
		m_fbSpecular = OpenGLBaseRenderer.makeFloatBuffer( f4Specular );
		m_fShininess = fShininess;
	}

	public Material()
	{
		float[] f4Ambient = { 0.2f, 0.2f, 0.2f, 1.0f };
		float[] f4Diffuse = { 0.8f, 0.8f, 0.8f, 1.0f };
		float[] f4Specular = { 0.0f, 0.0f, 0.0f, 1.0f };
		float fShininess = 0.0f;
		m_fbAmbient = OpenGLBaseRenderer.makeFloatBuffer( f4Ambient );
		m_fbDiffuse = OpenGLBaseRenderer.makeFloatBuffer( f4Diffuse );
		m_fbSpecular = OpenGLBaseRenderer.makeFloatBuffer( f4Specular );
		m_fShininess = fShininess;
	}

	public FloatBuffer getAmbientBuffer()
	{
		return m_fbAmbient;
	}

	public FloatBuffer getDiffuseBuffer()
	{
		return m_fbDiffuse;
	}

	public FloatBuffer getSpecularBuffer()
	{
		return m_fbSpecular;
	}

	public float getShininess()
	{
		return m_fShininess;
	}
}
