package com.hiramine.modelvieweretude;

import java.io.File;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.Window;
import android.view.WindowManager;

public class ModelViewerEtudeActivity extends Activity
{
	// リクエストコード
	private static final int	REQUEST_FILESELECT		= 0;
	// オプションメニューID
	private static final int	MENUID_FILE				= 1;
	private static final int	MENUGROUP_1FINGERDRAG	= 10;
	private static final int	MENUID_1FINGERDRAG_NONE	= 11;
	private static final int	MENUID_1FINGERDRAG_SPIN	= 12;
	private static final int	MENUID_1FINGERDRAG_PAN	= 13;
	private static final int	MENUID_1FINGERDRAG_ZOOM	= 14;
	private static final int	MENUID_RENDER_POINT		= 21;
	private static final int	MENUID_RENDER_LINE		= 22;
	private static final int	MENUID_RENDER_FACE		= 23;
	private static final int	MENUID_PICK_POINT		= 31;
	private static final int	MENUID_PICK_LINE		= 32;
	private static final int	MENUID_PICK_FACE		= 33;

	private ModelViewerView		m_modelviewerview;
	private String				m_strInitialDir			= "/";	// 初期フォルダ

	@Override
	public void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );

		// フルスクリーンの指定
		getWindow().clearFlags( WindowManager.LayoutParams.FLAG_FORCE_NOT_FULLSCREEN );
		getWindow().addFlags( WindowManager.LayoutParams.FLAG_FULLSCREEN );

		// タイトルなし
		requestWindowFeature( Window.FEATURE_NO_TITLE );

		// GLSurfaceViewの生成
		m_modelviewerview = new ModelViewerView( this );

		// ActivityにViewのセット
		setContentView( m_modelviewerview );
	}

	// 他のアクティビティが起動したことで、バックグラウンドに追いやられた時
	@Override
	protected void onPause()
	{
		m_modelviewerview.onPause();
		super.onPause();
	}

	// ポーズから復帰する時
	@Override
	protected void onResume()
	{
		super.onResume();
		m_modelviewerview.onResume();
	}

	// オプションメニュー生成時
	@Override
	public boolean onCreateOptionsMenu( Menu menu )
	{
		super.onCreateOptionsMenu( menu );
		MenuItem menuitem;
		SubMenu submenu;

		menu.add( 0, MENUID_FILE, 0, "Select File..." );
		submenu = menu.addSubMenu( "1 Finger Drag..." );
		menuitem = submenu.add( MENUGROUP_1FINGERDRAG, MENUID_1FINGERDRAG_NONE, 1, "None" );
		menuitem.setChecked( ETRACKINGMODE.TM_NONE == m_modelviewerview.m_eTrackingMode_1fingerdrag );
		menuitem = submenu.add( MENUGROUP_1FINGERDRAG, MENUID_1FINGERDRAG_SPIN, 2, "Spin" );
		menuitem.setChecked( ETRACKINGMODE.TM_SPIN == m_modelviewerview.m_eTrackingMode_1fingerdrag );
		menuitem = submenu.add( MENUGROUP_1FINGERDRAG, MENUID_1FINGERDRAG_PAN, 3, "Pan" );
		menuitem.setChecked( ETRACKINGMODE.TM_PAN == m_modelviewerview.m_eTrackingMode_1fingerdrag );
		menuitem = submenu.add( MENUGROUP_1FINGERDRAG, MENUID_1FINGERDRAG_ZOOM, 4, "Zoom" );
		menuitem.setChecked( ETRACKINGMODE.TM_ZOOM == m_modelviewerview.m_eTrackingMode_1fingerdrag );
		submenu.setGroupCheckable( MENUGROUP_1FINGERDRAG, true, true );

		submenu = menu.addSubMenu( "Render..." );
		menuitem = submenu.add( 0, MENUID_RENDER_POINT, 1, "Point" );
		menuitem.setCheckable( true );
		menuitem.setChecked( m_modelviewerview.getRenderer().m_bRenderPoint );
		menuitem = submenu.add( 0, MENUID_RENDER_LINE, 2, "Line" );
		menuitem.setCheckable( true );
		menuitem.setChecked( m_modelviewerview.getRenderer().m_bRenderLine );
		menuitem = submenu.add( 0, MENUID_RENDER_FACE, 3, "Face" );
		menuitem.setCheckable( true );
		menuitem.setChecked( m_modelviewerview.getRenderer().m_bRenderFace );

		submenu = menu.addSubMenu( "Pick..." );
		menuitem = submenu.add( 0, MENUID_PICK_POINT, 1, "Point" );
		menuitem.setCheckable( true );
		menuitem.setChecked( m_modelviewerview.getRenderer().m_bPickPoint );
		menuitem = submenu.add( 0, MENUID_PICK_LINE, 2, "Line" );
		menuitem.setCheckable( true );
		menuitem.setChecked( m_modelviewerview.getRenderer().m_bPickLine );
		menuitem = submenu.add( 0, MENUID_PICK_FACE, 3, "Face" );
		menuitem.setCheckable( true );
		menuitem.setChecked( m_modelviewerview.getRenderer().m_bPickFace );

		return true;
	}

	// オプションメニュー選択時
	@Override
	public boolean onOptionsItemSelected( MenuItem item )
	{
		switch( item.getItemId() )
		{
		case MENUID_FILE:
			// ファイル選択アクティビティ
			Intent intent = new Intent( this, FileSelectionActivity.class );
			intent.putExtra( "initialdir", m_strInitialDir );
			intent.putExtra( "ext", "stl" );
			startActivityForResult( intent, REQUEST_FILESELECT );
			return true;
		case MENUID_1FINGERDRAG_NONE:
			item.setChecked( true );
			m_modelviewerview.m_eTrackingMode_1fingerdrag = ETRACKINGMODE.TM_NONE;
			return true;
		case MENUID_1FINGERDRAG_SPIN:
			item.setChecked( true );
			m_modelviewerview.m_eTrackingMode_1fingerdrag = ETRACKINGMODE.TM_SPIN;
			return true;
		case MENUID_1FINGERDRAG_PAN:
			item.setChecked( true );
			m_modelviewerview.m_eTrackingMode_1fingerdrag = ETRACKINGMODE.TM_PAN;
			return true;
		case MENUID_1FINGERDRAG_ZOOM:
			item.setChecked( true );
			m_modelviewerview.m_eTrackingMode_1fingerdrag = ETRACKINGMODE.TM_ZOOM;
			return true;
		case MENUID_RENDER_POINT:
			item.setChecked( !item.isChecked() );
			m_modelviewerview.getRenderer().m_bRenderPoint = item.isChecked();
			m_modelviewerview.requestRender(); // 再描画
			return true;
		case MENUID_RENDER_LINE:
			item.setChecked( !item.isChecked() );
			m_modelviewerview.getRenderer().m_bRenderLine = item.isChecked();
			m_modelviewerview.requestRender(); // 再描画
			return true;
		case MENUID_RENDER_FACE:
			item.setChecked( !item.isChecked() );
			m_modelviewerview.getRenderer().m_bRenderFace = item.isChecked();
			m_modelviewerview.requestRender(); // 再描画
			return true;
		case MENUID_PICK_POINT:
			item.setChecked( !item.isChecked() );
			m_modelviewerview.getRenderer().m_bPickPoint = item.isChecked();
			return true;
		case MENUID_PICK_LINE:
			item.setChecked( !item.isChecked() );
			m_modelviewerview.getRenderer().m_bPickLine = item.isChecked();
			return true;
		case MENUID_PICK_FACE:
			item.setChecked( !item.isChecked() );
			m_modelviewerview.getRenderer().m_bPickFace = item.isChecked();
			return true;
		}
		return false;
	}

	// アクティビティ呼び出し結果の取得
	@Override
	protected void onActivityResult( int requestCode,
										int resultCode,
										Intent intent )
	{
		if( REQUEST_FILESELECT == requestCode && RESULT_OK == resultCode )
		{
			Bundle extras = intent.getExtras();
			if( null != extras )
			{
				File file = (File)extras.getSerializable( "file" );
				m_modelviewerview.loadModelFile( file.getPath() );
				m_strInitialDir = file.getParent();
			}
		}
	}
}
