package com.hiramine.modelvieweretude;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.FloatMath;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.widget.Toast;

public class ModelViewerView extends GLSurfaceView
		implements GestureDetector.OnGestureListener
{
	private ModelViewerRenderer	m_renderer;
	private GestureDetector		m_gesturedetector;				// 長押し用
	public ETRACKINGMODE		m_eTrackingMode_1fingerdrag;	// １本指ドラッグで行うトラッキングモード

	public ModelViewerRenderer getRenderer()
	{
		return m_renderer;
	}

	public ModelViewerView( Context context )
	{
		super( context );

		// １本指ドラッグで行うトラッキングモード
		m_eTrackingMode_1fingerdrag = ETRACKINGMODE.TM_SPIN;

		// Rendererの作成
		m_renderer = new ModelViewerRenderer();

		// GLSurfaceViewにRendererをセット
		setRenderer( m_renderer );

		// 絶え間ないレンダリングではなく都度のレンダリング（setRenderer()よりも後に呼び出す必要あり）
		setRenderMode( GLSurfaceView.RENDERMODE_WHEN_DIRTY );

		// モデルの作成および登録
		//m_renderer.setModel( makeModel() );

		// GestureDetectorの作成
		m_gesturedetector = new GestureDetector( context, this );
	}

	@Override
	public boolean onTouchEvent( MotionEvent event )
	{
		// ジェスチャ処理
		if( m_gesturedetector.onTouchEvent( event ) )
		{
			return true;
		}

		int action = event.getAction();
		int pointcount = event.getPointerCount();
		final float fX = event.getX();
		final float fY = event.getY();

		switch( action & MotionEvent.ACTION_MASK )
		{
		// トラッキングの開始
		case MotionEvent.ACTION_DOWN:
		case MotionEvent.ACTION_POINTER_DOWN:
			if( 1 == pointcount )
			{ // １つの指でドラッグ＝＞スピン
				// １本指ドラッグで行うトラッキングモードを指定する
				m_renderer.beginTracking( fX, fY, m_eTrackingMode_1fingerdrag );
			}
			else if( 2 == pointcount )
			{ // ２つの指でドラッグ＝＞ズーム
				float fX1 = event.getX( 1 );
				float fY1 = event.getY( 1 );
				final float fDistance = FloatMath.sqrt( ( fX1 - fX ) * ( fX1 - fX ) + ( fY1 - fY ) * ( fY1 - fY ) );
				m_renderer.beginTracking( -fDistance, -fDistance, ETRACKINGMODE.TM_ZOOM );
			}
			break;
		// トラッキングの終了
		case MotionEvent.ACTION_UP:
		case MotionEvent.ACTION_POINTER_UP:
			m_renderer.endTracking();
			break;
		// トラッキング
		case MotionEvent.ACTION_MOVE:
			if( 2 == pointcount
					&& ETRACKINGMODE.TM_ZOOM == m_renderer.getTrackingMode() )
			{ // ズームは、１つ目の指の座標値ではなく、２つの指の距離で処理する。
				float fX1 = event.getX( 1 );
				float fY1 = event.getY( 1 );
				final float fDistance = FloatMath.sqrt( ( fX1 - fX ) * ( fX1 - fX ) + ( fY1 - fY ) * ( fY1 - fY ) );
				m_renderer.doTracking( -fDistance, -fDistance );
				requestRender(); // 再描画
			}
			else
			{ // 通常は、１つ目の指の座標値で処理する。
				m_renderer.doTracking( fX, fY );
				requestRender(); // 再描画
			}
			break;
		}

		return true;
	}

	// モデルの作成
	/*private Model makeModel()
	{
		float[] afVertex = {
				-5.0f, -5.0f, -5.0f,
				5.0f, -5.0f, -5.0f,
				-5.0f, 5.0f, -5.0f,

				5.0f, -5.0f, -5.0f,
				5.0f, 5.0f, -5.0f,
				-5.0f, 5.0f, -5.0f,

				5.0f, -5.0f, -5.0f,
				5.0f, -5.0f, 5.0f,
				5.0f, 5.0f, -5.0f,

				5.0f, -5.0f, 5.0f,
				5.0f, 5.0f, 5.0f,
				5.0f, 5.0f, -5.0f,

				5.0f, -5.0f, 5.0f,
				-5.0f, -5.0f, 5.0f,
				5.0f, 5.0f, 5.0f,

				-5.0f, -5.0f, 5.0f,
				-5.0f, 5.0f, 5.0f,
				5.0f, 5.0f, 5.0f,

				-5.0f, -5.0f, 5.0f,
				-5.0f, -5.0f, -5.0f,
				-5.0f, 5.0f, 5.0f,

				-5.0f, -5.0f, -5.0f,
				-5.0f, 5.0f, -5.0f,
				-5.0f, 5.0f, 5.0f,

				-5.0f, 5.0f, -5.0f,
				5.0f, 5.0f, -5.0f,
				-5.0f, 5.0f, 5.0f,

				5.0f, 5.0f, -5.0f,
				5.0f, 5.0f, 5.0f,
				-5.0f, 5.0f, 5.0f,

				-5.0f, -5.0f, 5.0f,
				5.0f, -5.0f, 5.0f,
				-5.0f, -5.0f, -5.0f,

				5.0f, -5.0f, 5.0f,
				5.0f, -5.0f, -5.0f,
				-5.0f, -5.0f, -5.0f };

		return new Model( afVertex );
	}*/

	public boolean onDown( MotionEvent arg0 )
	{
		return false;
	}

	public boolean onFling( MotionEvent e1, MotionEvent e2, float velocityX, float velocityY )
	{
		return false;
	}

	public void onLongPress( MotionEvent e )
	{
		final float fX = e.getX();
		final float fY = e.getY();
		queueEvent( new Runnable()
		{
			public void run()
			{
				if( m_renderer.doPicking( fX, fY ) )
				{
					requestRender(); // 再描画
				}
			}
		} );
	}

	public boolean onScroll( MotionEvent e1, MotionEvent e2, float distanceX, float distanceY )
	{
		return false;
	}

	public void onShowPress( MotionEvent e )
	{

	}

	public boolean onSingleTapUp( MotionEvent e )
	{
		return false;
	}

	public void loadModelFile( String strPath )
	{
		final Model model = StlFileLoader.load( strPath );
		if( null == model )
		{
			Toast.makeText( getContext(), "Failed to load file : " + strPath, Toast.LENGTH_SHORT ).show();
			return;
		}
		// OpenGL関数呼び出しがあるので、イベントキューイングする。
		queueEvent( new Runnable()
		{
			public void run()
			{
				m_renderer.setModel( model );
				requestRender(); // 再描画
			}
		} );
	}

	// OpenGL描画コンテキストの消失と再作成の対応。
	// OpenGL描画コンテキストが消失されようとするときには、破棄処理を実施する。レンダラクラスのpreSurfaceDestroy()で実施。
	// OpenGL描画コンテキストが再作成されたときには、構築処理を実施する。レンダラクラスのonSurfaceCreated()で実施。
	@Override
	public void onPause()
	{
		// OpenGL関数呼び出しがあるので、イベントキューイングする。
		queueEvent( new Runnable()
		{
			public void run()
			{
				m_renderer.preSurfaceDestroy();
			}
		} );
		super.onPause();
	}
}
