package com.hiramine.modelvieweretude;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;

import android.util.Log;

public class StlFileLoader
{
	public static Model load( String strPath )
	{
		File file = new File( strPath );
		long lFileSize = file.length();
		if( 0 == lFileSize )
		{
			return null;
		}

		try
		{
			BufferedReader br = new BufferedReader( new FileReader( strPath ) );

			br.mark( (int)lFileSize );

			// ファーストパース（要素数カウント）
			int[] aiCountTriangle = new int[1];
			if( !parse_first( br, aiCountTriangle ) )
			{
				return null;
			}

			// 領域確保
			if( 0 == aiCountTriangle[0] )
			{
				return null;
			}
			float[] af3Vertex = new float[aiCountTriangle[0] * 3 * 3];

			br.reset();

			// セカンドパース（値詰め）
			if( !parse_second( br, af3Vertex ) )
			{
				return null;
			}

			br.close();

			//return new Model( af3Vertex );

			// モデルデータ化
			float[] f4Ambient = { 0.25f, 0.20725f, 0.20725f, 1.0f };
			float[] f4Diffuse = { 1.0f, 0.829f, 0.829f, 1.0f };
			float[] f4Specular = { 0.296648f, 0.296648f, 0.296648f, 1.0f };
			float fShininess = 0.088f;
			Material material = new Material(f4Ambient, f4Diffuse, f4Specular, fShininess);
			Group[] aGroup = new Group[1];
			aGroup[0] = new Group( "", af3Vertex, null, material );
			return new Model( aGroup );
		}
		catch( Exception e )
		{
			Log.e( "StlFileLoader", "load error : " + e );
			return null;
		}
	}

	private static boolean parse_first( BufferedReader br, int[] aiCountTriangle )
	{
		// インプットのチェック
		if( null == aiCountTriangle )
		{
			return false;
		}
		// アウトプットの初期化
		aiCountTriangle[0] = 0;

		int iIndexTriangle = 0;

		while( true )
		{
			try
			{
				String strReadString = br.readLine();
				if( null == strReadString )
				{
					break;
				}
				StringTokenizer stReadString = new StringTokenizer( strReadString, ", \t\r\n" );
				if( !stReadString.hasMoreTokens() )
				{
					continue;
				}
				String token = stReadString.nextToken();
				if( token.equalsIgnoreCase( "endfacet" ) )
				{
					++iIndexTriangle;
					continue;
				}
			}
			catch( Exception e )
			{
				Log.e( "StlFileLoader", "parse_first error : " + e );
				return false;
			}
		}

		aiCountTriangle[0] = iIndexTriangle;
		return true;
	}

	private static boolean parse_second( BufferedReader br, float[] af3Vertex )
	{
		// インプットのチェック
		if( null == af3Vertex )
		{
			return false;
		}
		int iIndexTriangle = 0;
		int iIndex3 = 0;

		while( true )
		{
			try
			{
				String strReadString = br.readLine();
				if( null == strReadString )
				{
					break;
				}
				StringTokenizer stReadString = new StringTokenizer( strReadString, ", \t\r\n" );
				if( !stReadString.hasMoreTokens() )
				{
					continue;
				}
				String token = stReadString.nextToken();
				if( token.equalsIgnoreCase( "vertex" ) )
				{
					if( 3 <= iIndex3 )
					{
						continue;
					}
					af3Vertex[iIndexTriangle * 9 + iIndex3 * 3 + 0] = Float.valueOf( stReadString.nextToken() );
					af3Vertex[iIndexTriangle * 9 + iIndex3 * 3 + 1] = Float.valueOf( stReadString.nextToken() );
					af3Vertex[iIndexTriangle * 9 + iIndex3 * 3 + 2] = Float.valueOf( stReadString.nextToken() );
					++iIndex3;
					continue;
				}
				else if( token.equalsIgnoreCase( "facet" ) )
				{ // 面法線ベクトル
					iIndex3 = 0;
					continue;
				}
				else if( token.equalsIgnoreCase( "endfacet" ) )
				{
					++iIndexTriangle;
					continue;
				}
				else if( token.equalsIgnoreCase( "solid" ) )
				{ // ソリッド名
					continue;
				}
			}
			catch( Exception e )
			{
				Log.e( "StlFileLoader", "parse_second error : " + e );
				return false;
			}
		}
		return true;
	}
}
