#include "stdafx.h"
#include "HttpSyncRequest.h"

#include "NhConversion.h"

#define URLBUFFER_SIZE		(4096)

void CHttpSyncRequest::Clear()
{
	if( m_hRequest )
	{
		WinHttpSetStatusCallback( m_hRequest, NULL, 0, NULL );
		WinHttpCloseHandle(m_hRequest);
		m_hRequest = NULL;
	}
	if( m_hConnect )
	{
		WinHttpCloseHandle(m_hConnect);
		m_hConnect = NULL;
	}
	m_ssRead = std::stringstream();
}

void CHttpSyncRequest::SendRequest( HINTERNET hSession,
								const tstring& tstrUrl,
								const tstring& tstrParameter,
								BOOL bIsHttpVerbPost )
{
	// ڑ͏Ȃ
	if( IsConnected() )
	{
		return;
	}

	// Cvbg`FbN
	if( NULL == hSession
	 || 0 == tstrUrl.length() )
	{
		RequestFailed( _T("URLs") );
		return;
	}

	// ϐ
	wstring wstrServer;
	INTERNET_PORT nPort = 0;
	wstring wstrVerb;
	wstring wstrObjectName;
	tstring wstrHeaders;
	std::string strOptional;

	// URL
	URL_COMPONENTS urlcomponents;
	ZeroMemory( &urlcomponents, sizeof(URL_COMPONENTS) );
	urlcomponents.dwStructSize = sizeof(URL_COMPONENTS);
	WCHAR wszHostName[URLBUFFER_SIZE];
	WCHAR wszUrlPath[URLBUFFER_SIZE];
	urlcomponents.lpszHostName	= wszHostName;
	urlcomponents.lpszUrlPath	= wszUrlPath;
	urlcomponents.dwHostNameLength	= URLBUFFER_SIZE;
	urlcomponents.dwUrlPathLength	= URLBUFFER_SIZE;
	if( !WinHttpCrackUrl(	tstrUrl.c_str(),
							0,
							0,
							&urlcomponents ) )
	{	// URL̉͂Ɏs
		RequestFailed( _T("URL͂Ɏs") );
		return;
	}

	wstrServer		= urlcomponents.lpszHostName;
	wstrObjectName	= urlcomponents.lpszUrlPath;
	nPort			= urlcomponents.nPort;

	// HTTPHTTPSȊO
	DWORD dwOpenRequestFlag = (INTERNET_SCHEME_HTTPS == urlcomponents.nScheme) ? WINHTTP_FLAG_SECURE : 0;

	// POSTGET
	if( bIsHttpVerbPost )
	{	// POST
		wstrVerb	= L"POST";
		wstrHeaders	= L"Content-Type: application/x-www-form-urlencoded";
		if( 0 != tstrParameter.length() )
		{	// p[^AMIvVf[^ɕϊ
			char* pszOptional = NhT2M( tstrParameter.c_str() );	// charɕϊ
			strOptional = pszOptional;
			free( pszOptional );
		}
	}
	else
	{	// GET
		wstrVerb	= L"GET";
		wstrHeaders	= L"";
		if( 0 != tstrParameter.length() )
		{	// IuWFNgƃp[^u?vŘA
			WCHAR* pwszBuffer = NhT2W( tstrParameter.c_str() );
			wstrObjectName += L"?" + wstring(pwszBuffer);
			free( pwszBuffer );
		}
	}

	// HTTPڑ
	m_hConnect = WinHttpConnect( hSession,
								 wstrServer.c_str(),
								 nPort,
								 0 );
	if( NULL == m_hConnect )
	{
		RequestFailed( _T("HTTPڑɎs") );
		return;
	}
	
	// HTTPڑJ
	m_hRequest = WinHttpOpenRequest( m_hConnect,
									 wstrVerb.c_str(),
									 wstrObjectName.c_str(),
									 NULL,
									 WINHTTP_NO_REFERER,
									 WINHTTP_DEFAULT_ACCEPT_TYPES,
									 dwOpenRequestFlag );
	if( NULL == m_hRequest )
	{
		RequestFailed( _T("HTTPڑJɎs") );
		return;
	}

	// NGXg̑M
	if( !WinHttpSendRequest( m_hRequest, 
							 wstrHeaders.c_str(),
							 wstrHeaders.length(),
							 (LPVOID)strOptional.c_str(),
							 strOptional.length() * sizeof(char),
							 strOptional.length() * sizeof(char),
							 (DWORD_PTR)0) )
	{
		RequestFailed( _T("NGXg̑MɎs") );
		return;
	}

	// X|X̓̑ҋ@
	if( !WinHttpReceiveResponse( m_hRequest, NULL ) )
	{
		RequestFailed( _T("WinHttpReceiveResponse()Ɏs") );
		return;
	}

	// Xe[^XR[h̎擾
	DWORD dwStatusCode = 0;
	DWORD dwStatusCodeSize = sizeof(DWORD);
	if( !WinHttpQueryHeaders( m_hRequest,
								WINHTTP_QUERY_STATUS_CODE | WINHTTP_QUERY_FLAG_NUMBER,	// Xe[^XR[hDWORD^Ŏ擾B
								WINHTTP_HEADER_NAME_BY_INDEX,	// wb_[̃|C^
								&dwStatusCode,				// obt@[
								&dwStatusCodeSize,			// obt@[TCY
								WINHTTP_NO_HEADER_INDEX))		// ŏɔwb_[̂ݎo
	{
		RequestFailed( _T("Xe[^XR[h̎擾Ɏs") );
		return;
	}
	if( HTTP_STATUS_OK != dwStatusCode )
	{
		RequestFailed( _T("Xe[^XR[hƂOKԂĂȂ") );
		return;
	}

	// X|Xf[^ǂݍ
	while( 1 )
	{
		// X|Xf[^₢킹
		DWORD dwSize = 0;
		if( !WinHttpQueryDataAvailable( m_hRequest, &dwSize ) )
		{
			RequestFailed( _T("WinHttpQueryDataAvailable()Ɏs") );
			return;
		}
		if( 0 == dwSize )
		{	// ǂݍݏI->R[obNI
			RequestSucceeded();
			return;
		}

		// X|Xf[^ǂݍ
		DWORD dwLength = dwSize + 1;
		char* pszBuffer = (char*)malloc( dwLength * sizeof(char) );
		if( !WinHttpReadData( m_hRequest,
								pszBuffer,		// obt@[
								dwSize,			// ǂݍރoCg
								NULL ) )
		{
			free( pszBuffer );
			RequestFailed( _T("WinHttpReadData()Ɏs") );
			return;
		}
		pszBuffer[dwSize] = '\0';
		m_ssRead << pszBuffer;
		free( pszBuffer );
	}
}
